﻿//////////////////////////////////////////////
// ImageEnvironmentProgramTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkAstraeus
#include "../../Utils/ProgramTracker.h"

#include "ImageEnvironmentEffectInfo.h"

/// Internals --------------------------------

namespace nkAstraeus
{
	struct ImageEnvironmentProgramIdGenerator
	{
		static unsigned long long generate (const ImageEnvironmentEffectInfo& info) ;
	} ;

	struct ImageEnvironmentProgramNameGenerator
	{
		constexpr static const char* name = "NILKINS_IMAGE_ENVIRONMENT_PROGRAM_" ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	class ImageEnvironmentProgramTracker final : public ProgramTracker<ImageEnvironmentEffectInfo, ImageEnvironmentProgramIdGenerator, ImageEnvironmentProgramNameGenerator>
	{
		public :

			// Functions
			// Constructor, destructor
			ImageEnvironmentProgramTracker (nkGraphics::System* graphicsSystem) noexcept ;
			virtual ~ImageEnvironmentProgramTracker () ;
	} ;
}